/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.ui.presenter;

import com.google.inject.Inject;
import info.msxlaunchers.openmsx.launcher.data.settings.Settings;
import info.msxlaunchers.openmsx.launcher.data.settings.constants.Language;
import info.msxlaunchers.openmsx.launcher.persistence.settings.SettingsPersister;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherException;
import info.msxlaunchers.openmsx.launcher.ui.presenter.LauncherExceptionCode;
import info.msxlaunchers.openmsx.launcher.ui.presenter.MainPresenter;
import info.msxlaunchers.openmsx.launcher.ui.presenter.SettingsPresenter;
import info.msxlaunchers.openmsx.launcher.ui.view.SettingsView;
import info.msxlaunchers.openmsx.launcher.ui.view.platform.PlatformViewProperties;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;

final class SettingsPresenterImpl
implements SettingsPresenter {
    private final SettingsView view;
    private final SettingsPersister settingsPersister;
    private final MainPresenter mainPresenter;
    private final PlatformViewProperties platformViewProperties;

    @Inject
    SettingsPresenterImpl(SettingsView view, SettingsPersister settingsPersister, MainPresenter launcherPresenter, PlatformViewProperties platformViewProperties) throws IOException {
        this.view = Objects.requireNonNull(view);
        this.settingsPersister = Objects.requireNonNull(settingsPersister);
        this.mainPresenter = Objects.requireNonNull(launcherPresenter);
        this.platformViewProperties = Objects.requireNonNull(platformViewProperties);
    }

    @Override
    public void onRequestSettingsScreen(Settings oldSettings, Set<String> databases, Language currentLanguage, String currentLanguageCode, boolean currentRightToLeft) {
        this.view.displaySettings(oldSettings, databases, currentLanguage, currentLanguageCode, currentRightToLeft);
    }

    @Override
    public void onRequestSettingsAction(String openMSXFullPath, String screenshotsFullPath, String defaultDatabase, String languageChoice, boolean showUpdateAllDatabases, boolean enableFeedService) throws LauncherException {
        String openMSXMachinesFullPath = null;
        openMSXMachinesFullPath = this.platformViewProperties.isMachinesFolderInsideOpenMSX() ? new File(openMSXFullPath, this.platformViewProperties.getOpenMSXMachinesPath()).getAbsolutePath() : this.platformViewProperties.getOpenMSXMachinesPath();
        try {
            Language language = null;
            if (languageChoice != null) {
                language = Language.valueOf(languageChoice);
            }
            Settings newSettings = new Settings(openMSXFullPath, openMSXMachinesFullPath, screenshotsFullPath, defaultDatabase, language, showUpdateAllDatabases, enableFeedService);
            this.settingsPersister.saveSettings(newSettings);
            this.mainPresenter.onAcceptSettingsAction(newSettings);
        }
        catch (IOException e) {
            throw new LauncherException(LauncherExceptionCode.ERR_CANNOT_SAVE_SETTINGS);
        }
    }
}

